/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.io.IOException;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.webapp.webxml.DelegatedFacesServlet;
import org.apache.myfaces.webapp.DefaultFacesInitializer;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.StartupServletContextListener;

public class MyFacesServlet
implements Servlet,
DelegatedFacesServlet {
    private static final Log log = LogFactory.getLog(MyFacesServlet.class);
    private final FacesServlet delegate = new FacesServlet();
    private FacesInitializer _facesInitializer;

    protected FacesInitializer getFacesInitializer() {
        if (this._facesInitializer == null) {
            this._facesInitializer = new DefaultFacesInitializer();
        }
        return this._facesInitializer;
    }

    public void setFacesInitializer(FacesInitializer facesInitializer) {
        this._facesInitializer = facesInitializer;
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public ServletConfig getServletConfig() {
        return this.delegate.getServletConfig();
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        Boolean b = (Boolean)servletContext.getAttribute(StartupServletContextListener.FACES_INIT_DONE);
        if (b == null || !b.booleanValue()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"ServletContextListener not yet called");
            }
            this.getFacesInitializer().initFaces(servletConfig.getServletContext());
        }
        this.delegate.init(servletConfig);
        log.info((Object)("MyFacesServlet for context '" + servletConfig.getServletContext().getRealPath("/") + "' initialized."));
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"MyFacesServlet service start");
        }
        this.delegate.service(request, response);
        if (log.isTraceEnabled()) {
            log.trace((Object)"MyFacesServlet service finished");
        }
    }
}

