/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.util.ArrayUtils;
import org.apache.myfaces.shared_impl.util.StringUtils;

public class HtmlGridRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlGridRendererBase.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        int columns;
        RendererUtils.checkParamValidity(facesContext, component, UIPanel.class);
        if (component instanceof HtmlPanelGrid) {
            columns = ((HtmlPanelGrid)component).getColumns();
        } else {
            Integer i = (Integer)component.getAttributes().get("columns");
            int n = columns = i != null ? i : 0;
        }
        if (columns <= 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Wrong columns attribute for PanelGrid " + component.getClientId(facesContext) + ": " + columns));
            }
            columns = 1;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", component);
        HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.flush();
        HtmlRendererUtils.renderTableCaption(facesContext, writer, component);
        this.renderHeaderOrFooter(facesContext, writer, component, columns, true);
        this.renderHeaderOrFooter(facesContext, writer, component, columns, false);
        this.renderChildren(facesContext, writer, component, columns);
        writer.endElement("table");
    }

    protected void renderHeaderOrFooter(FacesContext context, ResponseWriter writer, UIComponent component, int columns, boolean header) throws IOException {
        String styleClass;
        UIComponent facet = component.getFacet(header ? "header" : "footer");
        if (facet == null) {
            return;
        }
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.startElement(header ? "thead" : "tfoot", component);
        writer.startElement("tr", component);
        writer.startElement(header ? "th" : "td", component);
        String string = component instanceof HtmlPanelGrid ? (header ? ((HtmlPanelGrid)component).getHeaderClass() : ((HtmlPanelGrid)component).getFooterClass()) : (styleClass = header ? (String)component.getAttributes().get("headerClass") : (String)component.getAttributes().get("footerClass"));
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, header ? "headerClass" : "footerClass");
        }
        if (header) {
            writer.writeAttribute("scope", (Object)"colgroup", null);
        }
        writer.writeAttribute("colspan", (Object)Integer.toString(columns), null);
        HtmlRendererUtils.writePrettyLineSeparator(context);
        RendererUtils.renderChild(context, facet);
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.endElement(header ? "th" : "td");
        writer.endElement("tr");
        writer.endElement(header ? "thead" : "tfoot");
    }

    protected void renderChildren(FacesContext context, ResponseWriter writer, UIComponent component, int columns) throws IOException {
        String rowClasses;
        String columnClasses;
        writer.startElement("tbody", component);
        if (component instanceof HtmlPanelGrid) {
            columnClasses = ((HtmlPanelGrid)component).getColumnClasses();
            rowClasses = ((HtmlPanelGrid)component).getRowClasses();
        } else {
            columnClasses = (String)component.getAttributes().get("columnClasses");
            rowClasses = (String)component.getAttributes().get("rowClasses");
        }
        String[] columnClassesArray = columnClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnClasses, ','));
        int columnClassesCount = columnClassesArray.length;
        String[] rowClassesArray = rowClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowClasses, ','));
        int rowClassesCount = rowClassesArray.length;
        int childCount = this.getChildCount(component);
        if (childCount > 0) {
            int columnIndex = 0;
            int rowClassIndex = 0;
            boolean rowStarted = false;
            for (UIComponent child : this.getChildren(component)) {
                if (!child.isRendered()) continue;
                if (columnIndex == 0) {
                    if (rowStarted) {
                        writer.endElement("tr");
                        HtmlRendererUtils.writePrettyLineSeparator(context);
                    }
                    writer.startElement("tr", component);
                    if (rowClassIndex < rowClassesCount) {
                        writer.writeAttribute("class", (Object)rowClassesArray[rowClassIndex], null);
                    }
                    rowStarted = true;
                    if (++rowClassIndex == rowClassesCount) {
                        rowClassIndex = 0;
                    }
                }
                writer.startElement("td", component);
                if (columnIndex < columnClassesCount) {
                    writer.writeAttribute("class", (Object)columnClassesArray[columnIndex], null);
                }
                RendererUtils.renderChild(context, child);
                writer.endElement("td");
                if (++columnIndex < columns) continue;
                columnIndex = 0;
            }
            if (rowStarted) {
                if (columnIndex > 0) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("PanelGrid " + component.getClientId(context) + " has not enough children. Child count should be a multiple of the columns attribute."));
                    }
                    while (columnIndex < columns) {
                        writer.startElement("td", component);
                        if (columnIndex < columnClassesCount) {
                            writer.writeAttribute("class", (Object)columnClassesArray[columnIndex], null);
                        }
                        writer.endElement("td");
                        ++columnIndex;
                    }
                }
                writer.endElement("tr");
                HtmlRendererUtils.writePrettyLineSeparator(context);
            }
        }
        writer.endElement("tbody");
    }
}

