/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.HtmlResponseStateManager;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlResponseWriterImpl;

public class HtmlRenderKitImpl
extends RenderKit {
    private static final Log log = LogFactory.getLog(HtmlRenderKitImpl.class);
    private Map<String, Renderer> _renderers = new HashMap<String, Renderer>();
    private ResponseStateManager _responseStateManager = new HtmlResponseStateManager();

    private String key(String componentFamily, String rendererType) {
        return componentFamily + "." + rendererType;
    }

    public Renderer getRenderer(String componentFamily, String rendererType) {
        if (componentFamily == null) {
            throw new NullPointerException("component family must not be null.");
        }
        if (rendererType == null) {
            throw new NullPointerException("renderer type must not be null.");
        }
        Renderer renderer = this._renderers.get(this.key(componentFamily, rendererType));
        if (renderer == null) {
            log.warn((Object)("Unsupported component-family/renderer-type: " + componentFamily + "/" + rendererType));
        }
        return renderer;
    }

    public void addRenderer(String componentFamily, String rendererType, Renderer renderer) {
        if (componentFamily == null) {
            log.error((Object)"addRenderer: componentFamily = null is not allowed");
            throw new NullPointerException("component family must not be null.");
        }
        if (rendererType == null) {
            log.error((Object)"addRenderer: rendererType = null is not allowed");
            throw new NullPointerException("renderer type must not be null.");
        }
        if (renderer == null) {
            log.error((Object)"addRenderer: renderer = null is not allowed");
            throw new NullPointerException("renderer must not be null.");
        }
        String rendererKey = this.key(componentFamily, rendererType);
        if (this._renderers.get(rendererKey) != null) {
            log.debug((Object)("Overwriting renderer with family = " + componentFamily + " rendererType = " + rendererType + " renderer class = " + renderer.getClass().getName()));
        }
        this._renderers.put(rendererKey, renderer);
        if (log.isTraceEnabled()) {
            log.trace((Object)("add Renderer family = " + componentFamily + " rendererType = " + rendererType + " renderer class = " + renderer.getClass().getName()));
        }
    }

    public ResponseStateManager getResponseStateManager() {
        return this._responseStateManager;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeListString, String characterEncoding) {
        String selectedContentType = HtmlRendererUtils.selectContentType(contentTypeListString);
        if (characterEncoding == null) {
            characterEncoding = HtmlRendererUtils.DEFAULT_CHAR_ENCODING;
        }
        return new HtmlResponseWriterImpl(writer, selectedContentType, characterEncoding);
    }

    public ResponseStream createResponseStream(OutputStream outputStream) {
        final OutputStream output = outputStream;
        return new ResponseStream(){

            public void write(int b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b) throws IOException {
                output.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                output.write(b, off, len);
            }

            public void flush() throws IOException {
                output.flush();
            }

            public void close() throws IOException {
                output.close();
            }
        };
    }
}

