/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver.implicitobject;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import org.apache.myfaces.el.unified.resolver.implicitobject.ApplicationImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.ApplicationScopeImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.CookieImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.FacesContextImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.HeaderImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.HeaderValuesImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.ImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.InitParamImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.ParamImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.ParamValuesImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.RequestImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.RequestScopeImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.SessionImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.SessionScopeImplicitObject;
import org.apache.myfaces.el.unified.resolver.implicitobject.ViewImplicitObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitObjectResolver
extends ELResolver {
    private List<ImplicitObject> implicitObjects = new ArrayList<ImplicitObject>();

    public static ELResolver makeResolverForJSP() {
        ArrayList<ImplicitObject> forJSPList = new ArrayList<ImplicitObject>(2);
        forJSPList.add(new FacesContextImplicitObject());
        forJSPList.add(new ViewImplicitObject());
        return new ImplicitObjectResolver(forJSPList);
    }

    public static ELResolver makeResolverForFaces() {
        ArrayList<ImplicitObject> forFacesList = new ArrayList<ImplicitObject>(14);
        forFacesList.add(new ApplicationImplicitObject());
        forFacesList.add(new ApplicationScopeImplicitObject());
        forFacesList.add(new CookieImplicitObject());
        forFacesList.add(new FacesContextImplicitObject());
        forFacesList.add(new HeaderImplicitObject());
        forFacesList.add(new HeaderValuesImplicitObject());
        forFacesList.add(new InitParamImplicitObject());
        forFacesList.add(new ParamImplicitObject());
        forFacesList.add(new ParamValuesImplicitObject());
        forFacesList.add(new RequestImplicitObject());
        forFacesList.add(new RequestScopeImplicitObject());
        forFacesList.add(new SessionImplicitObject());
        forFacesList.add(new SessionScopeImplicitObject());
        forFacesList.add(new ViewImplicitObject());
        return new ImplicitObjectResolver(forFacesList);
    }

    private ImplicitObjectResolver() {
    }

    private ImplicitObjectResolver(List<ImplicitObject> implicitObjects) {
        this();
        this.implicitObjects = implicitObjects;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (base != null) {
            return;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return;
        }
        String strProperty = this.castAndIntern(property);
        for (ImplicitObject obj : this.implicitObjects) {
            if (!strProperty.equals(obj.getName())) continue;
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return false;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return false;
        }
        String strProperty = this.castAndIntern(property);
        for (ImplicitObject obj : this.implicitObjects) {
            if (!strProperty.equals(obj.getName())) continue;
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return null;
        }
        String strProperty = this.castAndIntern(property);
        for (ImplicitObject obj : this.implicitObjects) {
            if (!strProperty.equals(obj.getName())) continue;
            context.setPropertyResolved(true);
            return obj.getValue(context);
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return null;
        }
        String strProperty = this.castAndIntern(property);
        for (ImplicitObject obj : this.implicitObjects) {
            if (!strProperty.equals(obj.getName())) continue;
            context.setPropertyResolved(true);
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>(this.implicitObjects.size());
        for (ImplicitObject obj : this.implicitObjects) {
            descriptors.add(obj.getDescriptor());
        }
        return descriptors.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return String.class;
    }

    protected String castAndIntern(Object o) {
        String s = (String)o;
        return s.intern();
    }
}

