/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedAttributeResolver
extends ELResolver {
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (base != null) {
            return;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        Map<String, Object> scopedMap = this.findScopedMap(this.externalContext(context), property);
        if (scopedMap != null) {
            scopedMap.put((String)property, value);
        } else {
            this.externalContext(context).getRequestMap().put((String)property, value);
        }
        context.setPropertyResolved(true);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base == null) {
            context.setPropertyResolved(true);
        }
        return false;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        Map<String, Object> scopedMap = this.findScopedMap(this.externalContext(context), property);
        if (scopedMap != null) {
            context.setPropertyResolved(true);
            return scopedMap.get(property);
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        context.setPropertyResolved(true);
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> descriptorList = new ArrayList<FeatureDescriptor>();
        ExternalContext extContext = this.externalContext(context);
        this.addDescriptorsToList(descriptorList, extContext.getRequestMap());
        this.addDescriptorsToList(descriptorList, extContext.getSessionMap());
        this.addDescriptorsToList(descriptorList, extContext.getApplicationMap());
        return descriptorList.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return String.class;
    }

    private void addDescriptorsToList(List<FeatureDescriptor> descriptorList, Map scopeMap) {
        for (Object name : scopeMap.keySet()) {
            String strName = (String)name;
            Class<?> runtimeType = scopeMap.get(strName).getClass();
            descriptorList.add(this.makeDescriptor(strName, runtimeType));
        }
    }

    private FeatureDescriptor makeDescriptor(String name, Class runtimeType) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setValue("resolvableAtDesignTime", Boolean.TRUE);
        fd.setValue("type", runtimeType);
        fd.setName(name);
        fd.setDisplayName(name);
        fd.setShortDescription(name);
        fd.setExpert(false);
        fd.setHidden(false);
        fd.setPreferred(true);
        return fd;
    }

    private Map<String, Object> findScopedMap(ExternalContext extContext, Object property) {
        if (extContext == null) {
            return null;
        }
        Map scopedMap = extContext.getRequestMap();
        if (scopedMap.containsKey(property)) {
            return scopedMap;
        }
        scopedMap = extContext.getSessionMap();
        if (scopedMap.containsKey(property)) {
            return scopedMap;
        }
        scopedMap = extContext.getApplicationMap();
        if (scopedMap.containsKey(property)) {
            return scopedMap;
        }
        return null;
    }

    private FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    private ExternalContext externalContext(ELContext context) {
        FacesContext facesContext = this.facesContext(context);
        if (facesContext != null) {
            return this.facesContext(context).getExternalContext();
        }
        return null;
    }
}

