/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.util.Enumeration;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.webapp.AbstractMyFacesListener;
import org.apache.myfaces.webapp.DefaultFacesInitializer;
import org.apache.myfaces.webapp.FacesInitializer;

public class StartupServletContextListener
extends AbstractMyFacesListener
implements ServletContextListener {
    static final String FACES_INIT_DONE = StartupServletContextListener.class.getName() + ".FACES_INIT_DONE";
    private static final Log log = LogFactory.getLog(StartupServletContextListener.class);
    private FacesInitializer _facesInitializer;
    private ServletContext _servletContext;

    public void contextInitialized(ServletContextEvent event) {
        if (this._servletContext != null) {
            throw new IllegalStateException("context is already initialized");
        }
        this._servletContext = event.getServletContext();
        Boolean b = (Boolean)this._servletContext.getAttribute(FACES_INIT_DONE);
        if (b == null || !b.booleanValue()) {
            this.getFacesInitializer().initFaces(this._servletContext);
            this._servletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
        } else {
            log.info((Object)"MyFaces already initialized");
        }
    }

    protected FacesInitializer getFacesInitializer() {
        if (this._facesInitializer == null) {
            this._facesInitializer = new DefaultFacesInitializer();
        }
        return this._facesInitializer;
    }

    public void setFacesInitializer(FacesInitializer facesInitializer) {
        if (this._facesInitializer != null && this._facesInitializer != facesInitializer && this._servletContext != null) {
            this._facesInitializer.destroyFaces(this._servletContext);
        }
        this._facesInitializer = facesInitializer;
        if (this._servletContext != null) {
            facesInitializer.initFaces(this._servletContext);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.doPredestroy(event);
        if (this._facesInitializer != null && this._servletContext != null) {
            this._facesInitializer.destroyFaces(this._servletContext);
        }
        FactoryFinder.releaseFactories();
        this._servletContext = null;
    }

    private void doPredestroy(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        Enumeration attributes = ctx.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = (String)attributes.nextElement();
            Object value = ctx.getAttribute(name);
            this.doPreDestroy(value, name, "application");
        }
    }
}

