/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.util.Iterator;
import java.util.List;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.faces.FactoryFinder;
import javax.faces.context.ExternalContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ApplicationImpl;
import org.apache.myfaces.config.FacesConfigValidator;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.context.servlet.ServletExternalContextImpl;
import org.apache.myfaces.el.ResolverForJSPInitializer;
import org.apache.myfaces.el.unified.ELResolverBuilder;
import org.apache.myfaces.el.unified.ResolverBuilderForJSP;
import org.apache.myfaces.el.unified.resolver.FacesCompositeELResolver;
import org.apache.myfaces.shared_impl.util.StateUtils;
import org.apache.myfaces.shared_impl.webapp.webxml.WebXml;
import org.apache.myfaces.webapp.FacesELContextListener;
import org.apache.myfaces.webapp.FacesInitializer;

public class DefaultFacesInitializer
implements FacesInitializer {
    private static final Log log = LogFactory.getLog(DefaultFacesInitializer.class);
    private JspFactory _jspFactory;

    protected ELResolverBuilder createResolverBuilderForJSP(RuntimeConfig runtimeConfig) {
        return new ResolverBuilderForJSP(runtimeConfig);
    }

    public void initFaces(ServletContext servletContext) {
        try {
            log.trace((Object)"Initializing MyFaces");
            ServletExternalContextImpl externalContext = new ServletExternalContextImpl(servletContext, null, null);
            WebXml webXml = WebXml.getWebXml(externalContext);
            if (webXml == null) {
                log.warn((Object)"Couldn't find web.xml. Abort initializing MyFaces.");
                return;
            }
            if (webXml.getFacesServletMappings().isEmpty()) {
                log.warn((Object)"No mappings of FacesServlet found. Abort initializing MyFaces.");
                return;
            }
            try {
                Class.forName("org.apache.jasper.compiler.JspRuntimeContext");
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            JspFactory jspFactory = this.getJspFactory();
            if (log.isDebugEnabled()) {
                log.debug((Object)("jspfactory = " + jspFactory));
            }
            JspApplicationContext appCtx = jspFactory.getJspApplicationContext(servletContext);
            appCtx.addELContextListener((ELContextListener)new FacesELContextListener());
            RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
            runtimeConfig.setExpressionFactory(appCtx.getExpressionFactory());
            ApplicationImpl.setInitializingRuntimeConfig(runtimeConfig);
            new FacesConfigurator(externalContext).configure();
            this.validateFacesConfigIfNecessary(servletContext, externalContext);
            this.configureResolverForJSP(appCtx, runtimeConfig);
            if (!"false".equals(servletContext.getInitParameter("org.apache.myfaces.USE_ENCRYPTION"))) {
                StateUtils.initSecret(servletContext);
            }
            log.info((Object)("ServletContext '" + servletContext.getRealPath("/") + "' initialized."));
        }
        catch (Exception ex) {
            log.error((Object)("Error initializing MyFaces: " + ex.getMessage()), (Throwable)ex);
        }
    }

    protected JspFactory getJspFactory() {
        if (this._jspFactory == null) {
            return JspFactory.getDefaultFactory();
        }
        return this._jspFactory;
    }

    public void setJspFactory(JspFactory jspFactory) {
        this._jspFactory = jspFactory;
    }

    private void configureResolverForJSP(JspApplicationContext appCtx, RuntimeConfig runtimeConfig) {
        FacesCompositeELResolver facesCompositeELResolver = new FacesCompositeELResolver(FacesCompositeELResolver.Scope.JSP);
        appCtx.addELResolver((ELResolver)facesCompositeELResolver);
        ResolverForJSPInitializer resolverForJSPInitializer = new ResolverForJSPInitializer(this.createResolverBuilderForJSP(runtimeConfig), facesCompositeELResolver);
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Iterator iter = factory.getLifecycleIds();
        while (iter.hasNext()) {
            factory.getLifecycle((String)iter.next()).addPhaseListener((PhaseListener)resolverForJSPInitializer);
        }
    }

    protected void validateFacesConfigIfNecessary(ServletContext servletContext, ExternalContext externalContext) {
        if ("true".equals(servletContext.getInitParameter("org.apache.myfaces.VALIDATE"))) {
            List<String> list = FacesConfigValidator.validate(externalContext, servletContext.getRealPath("/"));
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                log.warn((Object)iterator.next());
            }
        }
    }

    public void destroyFaces(ServletContext servletContext) {
    }
}

