/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified;

import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.el.convert.PropertyResolverToELResolver;
import org.apache.myfaces.el.convert.VariableResolverToELResolver;

public class ResolverBuilderBase {
    private final RuntimeConfig _config;

    public ResolverBuilderBase(RuntimeConfig config) {
        this._config = config;
    }

    protected void addFromRuntimeConfig(CompositeELResolver elResolver) {
        if (this._config.getFacesConfigElResolvers() != null) {
            elResolver.add(this._config.getFacesConfigElResolvers());
        }
        if (this._config.getVariableResolver() != null) {
            elResolver.add(this.createELResolver(this._config.getVariableResolver()));
        } else if (this._config.getVariableResolverChainHead() != null) {
            elResolver.add(this.createELResolver(this._config.getVariableResolverChainHead()));
        }
        if (this._config.getPropertyResolver() != null) {
            elResolver.add(this.createELResolver(this._config.getPropertyResolver()));
        } else if (this._config.getPropertyResolverChainHead() != null) {
            elResolver.add(this.createELResolver(this._config.getPropertyResolverChainHead()));
        }
        if (this._config.getApplicationElResolvers() != null) {
            elResolver.add(this._config.getApplicationElResolvers());
        }
    }

    protected ELResolver createELResolver(VariableResolver resolver) {
        return new VariableResolverToELResolver(resolver);
    }

    protected ELResolver createELResolver(PropertyResolver resolver) {
        return new PropertyResolverToELResolver(resolver);
    }
}

