/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.jsp;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.DefaultViewHandlerSupport;
import org.apache.myfaces.application.InvalidViewIdException;
import org.apache.myfaces.application.ViewHandlerSupport;
import org.apache.myfaces.application.jsp.ViewResponseWrapper;

public class JspViewHandlerImpl
extends ViewHandler {
    private static final Log log = LogFactory.getLog(JspViewHandlerImpl.class);
    public static final String FORM_STATE_MARKER = "<!--@@JSF_FORM_STATE_MARKER@@-->";
    public static final int FORM_STATE_MARKER_LEN = "<!--@@JSF_FORM_STATE_MARKER@@-->".length();
    private static final String AFTER_VIEW_TAG_CONTENT_PARAM = JspViewHandlerImpl.class + ".AFTER_VIEW_TAG_CONTENT";
    private ViewHandlerSupport _viewHandlerSupport;

    public JspViewHandlerImpl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New ViewHandler instance created");
        }
    }

    public void setViewHandlerSupport(ViewHandlerSupport viewHandlerSupport) {
        this._viewHandlerSupport = viewHandlerSupport;
    }

    protected ViewHandlerSupport getViewHandlerSupport() {
        if (this._viewHandlerSupport == null) {
            this._viewHandlerSupport = new DefaultViewHandlerSupport();
        }
        return this._viewHandlerSupport;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        Iterator requestLocales = facesContext.getExternalContext().getRequestLocales();
        while (requestLocales.hasNext()) {
            Locale requestLocale = (Locale)requestLocales.next();
            Iterator supportedLocales = application.getSupportedLocales();
            while (supportedLocales.hasNext()) {
                Locale supportedLocale = (Locale)supportedLocales.next();
                if (requestLocale.getLanguage().equals(supportedLocale.getLanguage()) && (supportedLocale.getCountry() == null || supportedLocale.getCountry().length() == 0)) {
                    return supportedLocale;
                }
                if (!supportedLocale.equals(requestLocale)) continue;
                return supportedLocale;
            }
        }
        Locale defaultLocale = application.getDefaultLocale();
        return defaultLocale != null ? defaultLocale : Locale.getDefault();
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        Object renderKitId = facesContext.getExternalContext().getRequestMap().get("javax.faces.RenderKitId");
        if (renderKitId == null) {
            renderKitId = facesContext.getApplication().getDefaultRenderKitId();
        }
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        return renderKitId.toString();
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        String calculatedViewId = viewId;
        try {
            calculatedViewId = this.getViewHandlerSupport().calculateViewId(facesContext, viewId);
        }
        catch (InvalidViewIdException e) {
            this.sendSourceNotFound(facesContext, e.getMessage());
        }
        Application application = facesContext.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        Locale currentLocale = null;
        String currentRenderKitId = null;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot != null) {
            currentLocale = uiViewRoot.getLocale();
            currentRenderKitId = uiViewRoot.getRenderKitId();
        }
        uiViewRoot = (UIViewRoot)application.createComponent("javax.faces.ViewRoot");
        uiViewRoot.setViewId(calculatedViewId);
        if (currentLocale != null) {
            uiViewRoot.setLocale(currentLocale);
        } else {
            uiViewRoot.setLocale(applicationViewHandler.calculateLocale(facesContext));
        }
        if (currentRenderKitId != null) {
            uiViewRoot.setRenderKitId(currentRenderKitId);
        } else {
            uiViewRoot.setRenderKitId(applicationViewHandler.calculateRenderKitId(facesContext));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created view " + viewId));
        }
        return uiViewRoot;
    }

    private void sendSourceNotFound(FacesContext context, String message) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404, message);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        return this.getViewHandlerSupport().calculateActionURL(facesContext, viewId);
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            return facesContext.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException, FacesException {
        ResponseWriter newResponseWriter;
        HttpServletRequest httpServletRequest;
        HttpSession session;
        boolean errorResponse;
        if (viewToRender == null) {
            log.fatal((Object)"viewToRender must not be null");
            throw new NullPointerException("viewToRender must not be null");
        }
        if (!viewToRender.isRendered()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"View is not rendered");
            }
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = facesContext.getViewRoot().getViewId();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Rendering JSP view: " + viewId));
        }
        ServletResponse response = (ServletResponse)externalContext.getResponse();
        ServletRequest request = (ServletRequest)externalContext.getRequest();
        Locale locale = viewToRender.getLocale();
        response.setLocale(locale);
        Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)facesContext.getViewRoot().getLocale());
        ViewResponseWrapper wrappedResponse = new ViewResponseWrapper((HttpServletResponse)response);
        externalContext.setResponse((Object)wrappedResponse);
        externalContext.dispatch(viewId);
        externalContext.setResponse((Object)response);
        boolean bl = errorResponse = wrappedResponse.getStatus() < 200 || wrappedResponse.getStatus() > 299;
        if (errorResponse) {
            wrappedResponse.flushToWrappedResponse();
        }
        externalContext.getRequestMap().put(AFTER_VIEW_TAG_CONTENT_PARAM, wrappedResponse);
        if (externalContext.getRequest() instanceof HttpServletRequest && (session = (httpServletRequest = (HttpServletRequest)externalContext.getRequest()).getSession(false)) != null) {
            session.setAttribute("javax.faces.request.charset", (Object)response.getCharacterEncoding());
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(facesContext, viewToRender.getRenderKitId());
        StateMarkerAwareWriter stateAwareWriter = new StateMarkerAwareWriter();
        ResponseWriter oldResponseWriter = facesContext.getResponseWriter();
        if (oldResponseWriter != null) {
            newResponseWriter = oldResponseWriter.cloneWithWriter((Writer)stateAwareWriter);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Creating new ResponseWriter");
            }
            newResponseWriter = renderKit.createResponseWriter((Writer)stateAwareWriter, null, ((HttpServletRequest)externalContext.getRequest()).getCharacterEncoding());
        }
        facesContext.setResponseWriter(newResponseWriter);
        newResponseWriter.startDocument();
        viewToRender.encodeAll(facesContext);
        ResponseWriter responseWriter = oldResponseWriter != null ? oldResponseWriter.cloneWithWriter((Writer)response.getWriter()) : newResponseWriter.cloneWithWriter((Writer)response.getWriter());
        facesContext.setResponseWriter(responseWriter);
        stateAwareWriter.flushToWriter(response.getWriter());
        ViewResponseWrapper afterViewTagResponse = (ViewResponseWrapper)((Object)externalContext.getRequestMap().get(AFTER_VIEW_TAG_CONTENT_PARAM));
        externalContext.getRequestMap().remove(AFTER_VIEW_TAG_CONTENT_PARAM);
        if (afterViewTagResponse != null) {
            afterViewTagResponse.flushToWriter(response.getWriter());
        }
        newResponseWriter.endDocument();
        if (oldResponseWriter != null) {
            facesContext.setResponseWriter(oldResponseWriter);
        }
        response.flushBuffer();
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        Application application = facesContext.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        String renderKitId = applicationViewHandler.calculateRenderKitId(facesContext);
        String calculatedViewId = this.getViewHandlerSupport().calculateViewId(facesContext, viewId);
        UIViewRoot viewRoot = application.getStateManager().restoreView(facesContext, calculatedViewId, renderKitId);
        return viewRoot;
    }

    public void writeState(FacesContext facesContext) throws IOException {
        facesContext.getResponseWriter().write(FORM_STATE_MARKER);
    }

    private static class StateMarkerAwareWriter
    extends StringWriter {
        public void flushToWriter(Writer writer) throws IOException {
            int form_marker;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            StateManager stateManager = facesContext.getApplication().getStateManager();
            StringWriter stateWriter = new StringWriter();
            ResponseWriter realWriter = facesContext.getResponseWriter();
            facesContext.setResponseWriter(realWriter.cloneWithWriter((Writer)stateWriter));
            Object serializedView = stateManager.saveView(facesContext);
            stateManager.writeState(facesContext, serializedView);
            facesContext.setResponseWriter(realWriter);
            StringBuffer contentBuffer = this.getBuffer();
            StringBuffer state = stateWriter.getBuffer();
            while ((form_marker = contentBuffer.indexOf(JspViewHandlerImpl.FORM_STATE_MARKER)) > -1) {
                contentBuffer.replace(form_marker, form_marker + FORM_STATE_MARKER_LEN, state.toString());
            }
            int bufferLength = contentBuffer.length();
            int bufferSize = 512;
            for (int index = 0; index < bufferLength; index += bufferSize) {
                int maxSize = Math.min(bufferSize, bufferLength - index);
                char[] bufToWrite = new char[maxSize];
                contentBuffer.getChars(index, index + maxSize, bufToWrite, 0);
                writer.write(bufToWrite);
            }
        }
    }
}

