/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.faces.context.ExternalContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.annotation.AllAnnotationLifecycleProvider;
import org.apache.myfaces.config.annotation.DiscoverableLifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.config.annotation.NoAnnotationLifecyleProvider;
import org.apache.myfaces.config.annotation.NoInjectionAnnotationLifecycleProvider;
import org.apache.myfaces.config.annotation.ResourceAnnotationLifecycleProvider;
import org.apache.myfaces.shared_impl.util.ClassUtils;

public class DefaultLifecycleProviderFactory
extends LifecycleProviderFactory {
    private static Log log = LogFactory.getLog(DefaultLifecycleProviderFactory.class);
    private static LifecycleProvider LIFECYCLE_PROVIDER_INSTANCE;
    public static final String LIFECYCLE_PROVIDER;

    public LifecycleProvider getLifecycleProvider(ExternalContext externalContext) {
        if (LIFECYCLE_PROVIDER_INSTANCE == null) {
            if (externalContext == null) {
                log.info((Object)"No ExternalContext using fallback LifecycleProvider.");
                this.resolveFallbackLifecycleProvider();
            } else if (!this.resolveLifecycleProviderFromExternalContext(externalContext) && !this.resolveLifecycleProviderFromService(externalContext)) {
                this.resolveFallbackLifecycleProvider();
            }
            log.info((Object)("Using LifecycleProvider " + LIFECYCLE_PROVIDER_INSTANCE.getClass().getName()));
        }
        return LIFECYCLE_PROVIDER_INSTANCE;
    }

    public void release() {
        LIFECYCLE_PROVIDER_INSTANCE = null;
    }

    private boolean resolveLifecycleProviderFromExternalContext(ExternalContext externalContext) {
        try {
            Object obj;
            String lifecycleProvider = externalContext.getInitParameter(LIFECYCLE_PROVIDER);
            if (lifecycleProvider != null && (obj = this.createClass(lifecycleProvider, externalContext)) instanceof LifecycleProvider) {
                LIFECYCLE_PROVIDER_INSTANCE = (LifecycleProvider)obj;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"", (Throwable)e);
        }
        return false;
    }

    private boolean resolveLifecycleProviderFromService(ExternalContext externalContext) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaders loaders = new ClassLoaders();
        loaders.put(classLoader);
        DiscoverServiceNames dsn = new DiscoverServiceNames(loaders);
        ResourceNameIterator iter = dsn.findResourceNames(LIFECYCLE_PROVIDER);
        while (iter.hasNext()) {
            String className = iter.nextResourceName();
            try {
                DiscoverableLifecycleProvider discoverableLifecycleProvider;
                Object obj = this.createClass(className, externalContext);
                if (!DiscoverableLifecycleProvider.class.isAssignableFrom(obj.getClass()) || !(discoverableLifecycleProvider = (DiscoverableLifecycleProvider)obj).isAvailable()) continue;
                LIFECYCLE_PROVIDER_INSTANCE = discoverableLifecycleProvider;
                return true;
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
            }
            catch (InstantiationException e) {
                log.error((Object)"", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return false;
    }

    private Object createClass(String className, ExternalContext externalContext) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object obj;
        Class clazz = ClassUtils.classForName(className);
        try {
            Constructor constructor = clazz.getConstructor(ExternalContext.class);
            obj = constructor.newInstance(externalContext);
        }
        catch (NoSuchMethodException e) {
            obj = clazz.newInstance();
        }
        return obj;
    }

    private void resolveFallbackLifecycleProvider() {
        try {
            ClassUtils.classForName("javax.annotation.PreDestroy");
        }
        catch (ClassNotFoundException e) {
            LIFECYCLE_PROVIDER_INSTANCE = new NoAnnotationLifecyleProvider();
            return;
        }
        try {
            InitialContext context = new InitialContext();
            try {
                ClassUtils.classForName("javax.ejb.EJB");
                LIFECYCLE_PROVIDER_INSTANCE = new AllAnnotationLifecycleProvider(context);
            }
            catch (ClassNotFoundException e) {
                LIFECYCLE_PROVIDER_INSTANCE = new ResourceAnnotationLifecycleProvider(context);
            }
        }
        catch (NamingException e) {
            LIFECYCLE_PROVIDER_INSTANCE = new NoInjectionAnnotationLifecycleProvider();
            log.error((Object)"No InitialContext found. Using NoInjectionAnnotationProcessor.", (Throwable)e);
        }
    }

    static {
        LIFECYCLE_PROVIDER = LifecycleProvider.class.getName();
    }
}

