/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.InvalidViewIdException;
import org.apache.myfaces.application.ViewHandlerSupport;
import org.apache.myfaces.shared_impl.webapp.webxml.ServletMapping;
import org.apache.myfaces.shared_impl.webapp.webxml.WebXml;

public class DefaultViewHandlerSupport
implements ViewHandlerSupport {
    private static final String SERVLET_MAPPING = DefaultViewHandlerSupport.class.getName() + ".ServletMapping";
    private static final Log log = LogFactory.getLog(DefaultViewHandlerSupport.class);

    public String calculateViewId(FacesContext context, String viewId) {
        ServletMapping mapping = this.calculateServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.applyDefaultSuffix(context, viewId);
        } else if (mapping != null && viewId != null && mapping.getUrlPattern().startsWith(viewId)) {
            throw new InvalidViewIdException(viewId);
        }
        return viewId;
    }

    public String calculateActionURL(FacesContext context, String viewId) {
        if (viewId == null || !viewId.startsWith("/")) {
            throw new IllegalArgumentException("ViewId must start with a '/': " + viewId);
        }
        ServletMapping mapping = this.calculateServletMapping(context);
        ExternalContext externalContext = context.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        StringBuilder builder = new StringBuilder(contextPath);
        if (mapping != null) {
            if (mapping.isExtensionMapping()) {
                String contextSuffix = this.getContextSuffix(context);
                if (viewId.endsWith(contextSuffix)) {
                    builder.append(viewId.substring(0, viewId.indexOf(contextSuffix)));
                    builder.append(mapping.getExtension());
                } else {
                    builder.append(viewId);
                }
            } else {
                builder.append(mapping.getPrefix());
                builder.append(viewId);
            }
        } else {
            builder.append(viewId);
        }
        String calculatedActionURL = builder.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Calculated actionURL: '" + calculatedActionURL + "' for viewId: '" + viewId + "'"));
        }
        return calculatedActionURL;
    }

    protected ServletMapping calculateServletMapping(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        ServletMapping mapping = null;
        if (requestMap.containsKey(externalContext)) {
            mapping = (ServletMapping)requestMap.get(SERVLET_MAPPING);
        } else {
            String servletPath = externalContext.getRequestServletPath();
            String requestPathInfo = externalContext.getRequestPathInfo();
            WebXml webxml = WebXml.getWebXml(externalContext);
            List mappings = webxml.getFacesServletMappings();
            if (requestPathInfo == null) {
                int size = mappings.size();
                for (int i = 0; i < size && mapping == null; ++i) {
                    ServletMapping servletMapping = (ServletMapping)mappings.get(i);
                    String urlpattern = servletMapping.getUrlPattern();
                    String extension = urlpattern.substring(1, urlpattern.length());
                    if (servletPath.endsWith(extension)) {
                        mapping = servletMapping;
                        continue;
                    }
                    if (!servletPath.equals(urlpattern)) continue;
                    mapping = servletMapping;
                }
            } else {
                int size = mappings.size();
                for (int i = 0; i < size && mapping == null; ++i) {
                    ServletMapping servletMapping = (ServletMapping)mappings.get(i);
                    String urlpattern = servletMapping.getUrlPattern();
                    if (!servletPath.equals(urlpattern = urlpattern.substring(0, urlpattern.length() - 2))) continue;
                    mapping = servletMapping;
                }
            }
            if (mapping == null && mappings.size() > 0) {
                mapping = (ServletMapping)mappings.get(0);
            }
            if (mapping == null && log.isWarnEnabled()) {
                log.warn((Object)"no faces servlet mappings found");
            }
            requestMap.put(SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    protected String getContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".jsp";
        }
        return defaultSuffix;
    }

    protected String applyDefaultSuffix(FacesContext context, String viewId) {
        String defaultSuffix = this.getContextSuffix(context);
        if (viewId == null) {
            return null;
        }
        if (!viewId.endsWith(defaultSuffix)) {
            StringBuilder builder = new StringBuilder(viewId);
            int index = viewId.lastIndexOf(46);
            if (index != -1) {
                builder.replace(index, viewId.length(), defaultSuffix);
            } else {
                builder.append(defaultSuffix);
            }
            viewId = builder.toString();
            if (log.isTraceEnabled()) {
                log.trace((Object)("view id after applying the context suffix: " + viewId));
            }
        }
        return viewId;
    }
}

