/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ActionListenerImpl;
import org.apache.myfaces.application.NavigationHandlerImpl;
import org.apache.myfaces.application.jsp.JspStateManagerImpl;
import org.apache.myfaces.application.jsp.JspViewHandlerImpl;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.impl.digester.elements.Property;
import org.apache.myfaces.el.PropertyResolverImpl;
import org.apache.myfaces.el.VariableResolverToApplicationELResolverAdapter;
import org.apache.myfaces.el.convert.MethodExpressionToMethodBinding;
import org.apache.myfaces.el.convert.ValueBindingToValueExpression;
import org.apache.myfaces.el.convert.ValueExpressionToValueBinding;
import org.apache.myfaces.el.unified.ELResolverBuilder;
import org.apache.myfaces.el.unified.ResolverBuilderForFaces;
import org.apache.myfaces.el.unified.resolver.FacesCompositeELResolver;
import org.apache.myfaces.shared_impl.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationImpl
extends Application {
    private static final Log log = LogFactory.getLog(ApplicationImpl.class);
    private static final VariableResolver VARIABLERESOLVER = new VariableResolverToApplicationELResolverAdapter();
    private static final PropertyResolver PROPERTYRESOLVER = new PropertyResolverImpl();
    private static final ThreadLocal<RuntimeConfig> initializingRuntimeConfig = new ThreadLocal();
    private Collection<Locale> _supportedLocales = Collections.emptySet();
    private Locale _defaultLocale;
    private String _messageBundle;
    private ViewHandler _viewHandler;
    private NavigationHandler _navigationHandler;
    private ActionListener _actionListener;
    private String _defaultRenderKitId;
    private StateManager _stateManager;
    private ArrayList<ELContextListener> _elContextListeners;
    private final Map<String, Class> _converterIdToClassMap = Collections.synchronizedMap(new HashMap());
    private final Map<Class, String> _converterClassNameToClassMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, org.apache.myfaces.config.impl.digester.elements.Converter> _converterClassNameToConfigurationMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Class> _componentClassMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Class> _validatorClassMap = Collections.synchronizedMap(new HashMap());
    private final RuntimeConfig _runtimeConfig;
    private ELResolver elResolver;
    private ELResolverBuilder resolverBuilderForFaces;

    public ApplicationImpl() {
        this(ApplicationImpl.internalGetRuntimeConfig());
    }

    private static RuntimeConfig internalGetRuntimeConfig() {
        if (initializingRuntimeConfig.get() == null) {
            throw new IllegalStateException("The runtime config instance which is created while initialize myfaces must be set through ApplicationImpl.setInitializingRuntimeConfig");
        }
        return initializingRuntimeConfig.get();
    }

    ApplicationImpl(RuntimeConfig runtimeConfig) {
        if (runtimeConfig == null) {
            throw new IllegalArgumentException("runtimeConfig must mot be null");
        }
        this._viewHandler = new JspViewHandlerImpl();
        this._navigationHandler = new NavigationHandlerImpl();
        this._actionListener = new ActionListenerImpl();
        this._defaultRenderKitId = "HTML_BASIC";
        this._stateManager = new JspStateManagerImpl();
        this._elContextListeners = new ArrayList();
        this._runtimeConfig = runtimeConfig;
        if (log.isTraceEnabled()) {
            log.trace((Object)"New Application instance created");
        }
    }

    public static void setInitializingRuntimeConfig(RuntimeConfig config) {
        initializingRuntimeConfig.set(config);
    }

    public void addELResolver(ELResolver resolver) {
        if (FacesContext.getCurrentInstance() != null) {
            throw new IllegalStateException("It is illegal to add a resolver after the first request is processed");
        }
        if (resolver != null) {
            this._runtimeConfig.addApplicationElResolver(resolver);
        }
    }

    public ELResolver getELResolver() {
        if (this.elResolver == null) {
            this.elResolver = this.createFacesResolver();
        }
        return this.elResolver;
    }

    private ELResolver createFacesResolver() {
        FacesCompositeELResolver resolver = new FacesCompositeELResolver(FacesCompositeELResolver.Scope.Faces);
        this.getResolverBuilderForFaces().build(resolver);
        return resolver;
    }

    protected ELResolverBuilder getResolverBuilderForFaces() {
        if (this.resolverBuilderForFaces == null) {
            this.resolverBuilderForFaces = new ResolverBuilderForFaces(this._runtimeConfig);
        }
        return this.resolverBuilderForFaces;
    }

    public void setResolverBuilderForFaces(ELResolverBuilder factory) {
        this.resolverBuilderForFaces = factory;
    }

    public ResourceBundle getResourceBundle(FacesContext facesContext, String name) throws FacesException, NullPointerException {
        this.checkNull(facesContext, "facesContext");
        this.checkNull(name, "name");
        String bundleName = this.getBundleName(facesContext, name);
        if (bundleName == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null && viewRoot.getLocale() != null) {
            locale = viewRoot.getLocale();
        }
        try {
            return this.getResourceBundle(bundleName, locale, this.getClassLoader());
        }
        catch (MissingResourceException e) {
            throw new FacesException("Could not load resource bundle for name '" + name + "': " + e.getMessage(), (Throwable)e);
        }
    }

    ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    String getBundleName(FacesContext facesContext, String name) {
        org.apache.myfaces.config.impl.digester.elements.ResourceBundle bundle = this.getRuntimeConfig(facesContext).getResourceBundle(name);
        return bundle != null ? bundle.getBaseName() : null;
    }

    ResourceBundle getResourceBundle(String name, Locale locale, ClassLoader loader) throws MissingResourceException {
        return ResourceBundle.getBundle(name, locale, loader);
    }

    RuntimeConfig getRuntimeConfig(FacesContext facesContext) {
        return RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
    }

    FacesContext getFaceContext() {
        return FacesContext.getCurrentInstance();
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext facesContext, String componentType) throws FacesException, NullPointerException {
        this.checkNull(componentExpression, "componentExpression");
        this.checkNull(facesContext, "facesContext");
        this.checkNull(componentType, "componentType");
        ELContext elContext = facesContext.getELContext();
        try {
            UIComponent createdComponent;
            Object retVal = componentExpression.getValue(elContext);
            if (retVal instanceof UIComponent) {
                createdComponent = (UIComponent)retVal;
            } else {
                createdComponent = this.createComponent(componentType);
                componentExpression.setValue(elContext, (Object)createdComponent);
            }
            return createdComponent;
        }
        catch (FacesException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public ExpressionFactory getExpressionFactory() {
        return this._runtimeConfig.getExpressionFactory();
    }

    public Object evaluateExpressionGet(FacesContext context, String expression, Class expectedType) throws ELException {
        ELContext elContext = context.getELContext();
        return this.getExpressionFactory().createValueExpression(elContext, expression, expectedType).getValue(elContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addELContextListener(ELContextListener listener) {
        ArrayList<ELContextListener> arrayList = this._elContextListeners;
        synchronized (arrayList) {
            this._elContextListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeELContextListener(ELContextListener listener) {
        ArrayList<ELContextListener> arrayList = this._elContextListeners;
        synchronized (arrayList) {
            this._elContextListeners.remove(listener);
        }
    }

    public ELContextListener[] getELContextListeners() {
        return this._elContextListeners.toArray(new ELContextListener[0]);
    }

    public void setActionListener(ActionListener actionListener) {
        this.checkNull(actionListener, "actionListener");
        this._actionListener = actionListener;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set actionListener = " + actionListener.getClass().getName()));
        }
    }

    public ActionListener getActionListener() {
        return this._actionListener;
    }

    public Iterator<String> getComponentTypes() {
        return this._componentClassMap.keySet().iterator();
    }

    public Iterator<String> getConverterIds() {
        return this._converterIdToClassMap.keySet().iterator();
    }

    public Iterator<Class> getConverterTypes() {
        return this._converterClassNameToClassMap.keySet().iterator();
    }

    public void setDefaultLocale(Locale locale) {
        this.checkNull(locale, "locale");
        this._defaultLocale = locale;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set defaultLocale = " + locale.getCountry() + " " + locale.getLanguage()));
        }
    }

    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public void setMessageBundle(String messageBundle) {
        this.checkNull(messageBundle, "messageBundle");
        this._messageBundle = messageBundle;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set MessageBundle = " + messageBundle));
        }
    }

    public String getMessageBundle() {
        return this._messageBundle;
    }

    public void setNavigationHandler(NavigationHandler navigationHandler) {
        this.checkNull(navigationHandler, "navigationHandler");
        this._navigationHandler = navigationHandler;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set NavigationHandler = " + navigationHandler.getClass().getName()));
        }
    }

    public NavigationHandler getNavigationHandler() {
        return this._navigationHandler;
    }

    @Deprecated
    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.checkNull(propertyResolver, "propertyResolver");
        if (this.getFaceContext() != null) {
            throw new IllegalStateException("propertyResolver must be defined before request processing");
        }
        this._runtimeConfig.setPropertyResolver(propertyResolver);
        if (log.isTraceEnabled()) {
            log.trace((Object)("set PropertyResolver = " + propertyResolver.getClass().getName()));
        }
    }

    @Deprecated
    public PropertyResolver getPropertyResolver() {
        return PROPERTYRESOLVER;
    }

    public void setSupportedLocales(Collection<Locale> locales) {
        this.checkNull(locales, "locales");
        this._supportedLocales = locales;
        if (log.isTraceEnabled()) {
            log.trace((Object)"set SupportedLocales");
        }
    }

    public Iterator<Locale> getSupportedLocales() {
        return this._supportedLocales.iterator();
    }

    public Iterator<String> getValidatorIds() {
        return this._validatorClassMap.keySet().iterator();
    }

    @Deprecated
    public void setVariableResolver(VariableResolver variableResolver) {
        this.checkNull(variableResolver, "variableResolver");
        if (this.getFaceContext() != null) {
            throw new IllegalStateException("variableResolver must be defined before request processing");
        }
        this._runtimeConfig.setVariableResolver(variableResolver);
        if (log.isTraceEnabled()) {
            log.trace((Object)("set VariableResolver = " + variableResolver.getClass().getName()));
        }
    }

    @Deprecated
    public VariableResolver getVariableResolver() {
        return VARIABLERESOLVER;
    }

    public void setViewHandler(ViewHandler viewHandler) {
        this.checkNull(viewHandler, "viewHandler");
        this._viewHandler = viewHandler;
        if (log.isTraceEnabled()) {
            log.trace((Object)("set ViewHandler = " + viewHandler.getClass().getName()));
        }
    }

    public ViewHandler getViewHandler() {
        return this._viewHandler;
    }

    public void addComponent(String componentType, String componentClassName) {
        this.checkNull(componentType, "componentType");
        this.checkEmpty(componentType, "componentType");
        this.checkNull(componentClassName, "componentClassName");
        this.checkEmpty(componentClassName, "componentClassName");
        try {
            this._componentClassMap.put(componentType, ClassUtils.simpleClassForName(componentClassName));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Component class = " + componentClassName + " for type = " + componentType));
            }
        }
        catch (Exception e) {
            log.error((Object)("Component class " + componentClassName + " not found"), (Throwable)e);
        }
    }

    public void addConverter(String converterId, String converterClass) {
        this.checkNull(converterId, "converterId");
        this.checkEmpty(converterId, "converterId");
        this.checkNull(converterClass, "converterClass");
        this.checkEmpty(converterClass, "converterClass");
        try {
            this._converterIdToClassMap.put(converterId, ClassUtils.simpleClassForName(converterClass));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Converter id = " + converterId + " converterClass = " + converterClass));
            }
        }
        catch (Exception e) {
            log.error((Object)("Converter class " + converterClass + " not found"), (Throwable)e);
        }
    }

    public void addConverter(Class targetClass, String converterClass) {
        this.checkNull(targetClass, "targetClass");
        this.checkNull(converterClass, "converterClass");
        this.checkEmpty(converterClass, "converterClass");
        try {
            this._converterClassNameToClassMap.put(targetClass, converterClass);
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Converter for class = " + targetClass + " converterClass = " + converterClass));
            }
        }
        catch (Exception e) {
            log.error((Object)("Converter class " + converterClass + " not found"), (Throwable)e);
        }
    }

    public void addConverterConfiguration(String converterClassName, org.apache.myfaces.config.impl.digester.elements.Converter configuration) {
        this.checkNull(converterClassName, "converterClassName");
        this.checkEmpty(converterClassName, "converterClassName");
        this.checkNull(configuration, "configuration");
        this._converterClassNameToConfigurationMap.put(converterClassName, configuration);
    }

    public void addValidator(String validatorId, String validatorClass) {
        this.checkNull(validatorId, "validatorId");
        this.checkEmpty(validatorId, "validatorId");
        this.checkNull(validatorClass, "validatorClass");
        this.checkEmpty(validatorClass, "validatorClass");
        try {
            this._validatorClassMap.put(validatorId, ClassUtils.simpleClassForName(validatorClass));
            if (log.isTraceEnabled()) {
                log.trace((Object)("add Validator id = " + validatorId + " class = " + validatorClass));
            }
        }
        catch (Exception e) {
            log.error((Object)("Validator class " + validatorClass + " not found"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIComponent createComponent(String componentType) throws FacesException {
        Class componentClass;
        this.checkNull(componentType, "componentType");
        this.checkEmpty(componentType, "componentType");
        Map<String, Class> map = this._componentClassMap;
        synchronized (map) {
            componentClass = this._componentClassMap.get(componentType);
        }
        if (componentClass == null) {
            log.error((Object)("Undefined component type " + componentType));
            throw new FacesException("Undefined component type " + componentType);
        }
        try {
            return (UIComponent)componentClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate component componentType = " + componentType), (Throwable)e);
            throw new FacesException("Could not instantiate component componentType = " + componentType, (Throwable)e);
        }
    }

    @Deprecated
    public UIComponent createComponent(ValueBinding valueBinding, FacesContext facesContext, String componentType) throws FacesException {
        this.checkNull(valueBinding, "valueBinding");
        this.checkNull(facesContext, "facesContext");
        this.checkNull(componentType, "componentType");
        this.checkEmpty(componentType, "componentType");
        ValueBindingToValueExpression valExpression = new ValueBindingToValueExpression(valueBinding);
        return this.createComponent(valExpression, facesContext, componentType);
    }

    public Converter createConverter(String converterId) {
        this.checkNull(converterId, "converterId");
        this.checkEmpty(converterId, "converterId");
        Class converterClass = this._converterIdToClassMap.get(converterId);
        try {
            Converter converter = (Converter)converterClass.newInstance();
            this.setConverterProperties(converterClass, converter);
            return converter;
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate converter " + converterClass), (Throwable)e);
            throw new FacesException("Could not instantiate converter: " + converterClass, (Throwable)e);
        }
    }

    public Converter createConverter(Class targetClass) {
        this.checkNull(targetClass, "targetClass");
        return this.internalCreateConverter(targetClass);
    }

    private Converter internalCreateConverter(Class targetClass) {
        Class<?>[] interfaces;
        String converterClassName = this._converterClassNameToClassMap.get(targetClass);
        if (converterClassName == null && (interfaces = targetClass.getInterfaces()) != null) {
            int len = interfaces.length;
            for (int i = 0; i < len; ++i) {
                Converter converter = this.internalCreateConverter(interfaces[i]);
                if (converter == null) continue;
                return converter;
            }
        }
        if (converterClassName != null) {
            try {
                Class converterClass = ClassUtils.simpleClassForName(converterClassName);
                Converter converter = null;
                try {
                    Constructor constructor = converterClass.getConstructor(Class.class);
                    converter = (Converter)constructor.newInstance(targetClass);
                }
                catch (Exception e) {
                    converter = (Converter)converterClass.newInstance();
                }
                this.setConverterProperties(converterClass, converter);
                return converter;
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate converter " + converterClassName), (Throwable)e);
                throw new FacesException("Could not instantiate converter: " + converterClassName, (Throwable)e);
            }
        }
        if (targetClass == Long.TYPE) {
            return this.internalCreateConverter(Long.class);
        }
        if (targetClass == Boolean.TYPE) {
            return this.internalCreateConverter(Boolean.class);
        }
        if (targetClass == Double.TYPE) {
            return this.internalCreateConverter(Double.class);
        }
        if (targetClass == Byte.TYPE) {
            return this.internalCreateConverter(Byte.class);
        }
        if (targetClass == Short.TYPE) {
            return this.internalCreateConverter(Short.class);
        }
        if (targetClass == Integer.TYPE) {
            return this.internalCreateConverter(Integer.class);
        }
        if (targetClass == Float.TYPE) {
            return this.internalCreateConverter(Float.class);
        }
        if (targetClass == Character.TYPE) {
            return this.internalCreateConverter(Character.class);
        }
        Class superClazz = targetClass.getSuperclass();
        return superClazz != null ? this.internalCreateConverter(superClazz) : null;
    }

    private void setConverterProperties(Class converterClass, Converter converter) {
        org.apache.myfaces.config.impl.digester.elements.Converter converterConfig = this._converterClassNameToConfigurationMap.get(converterClass.getName());
        if (converterConfig != null) {
            Iterator<Property> it = converterConfig.getProperties();
            while (it.hasNext()) {
                Property property = it.next();
                try {
                    BeanUtils.setProperty((Object)converter, (String)property.getPropertyName(), (Object)property.getDefaultValue());
                }
                catch (Throwable th) {
                    log.error((Object)("Initializing converter : " + converterClass.getName() + " with property : " + property.getPropertyName() + " and value : " + property.getDefaultValue() + " failed."));
                }
            }
        }
    }

    @Deprecated
    public MethodBinding createMethodBinding(String reference, Class[] params) throws ReferenceSyntaxException {
        MethodExpression methodExpression;
        this.checkNull(reference, "reference");
        this.checkEmpty(reference, "reference");
        if (!reference.startsWith("#{") || !reference.endsWith("}")) {
            throw new ReferenceSyntaxException("Invalid method reference: '" + reference + "'");
        }
        if (params == null) {
            params = new Class[]{};
        }
        try {
            methodExpression = this.getExpressionFactory().createMethodExpression(this.threadELContext(), reference, Object.class, params);
        }
        catch (ELException e) {
            throw new ReferenceSyntaxException((Throwable)e);
        }
        return new MethodExpressionToMethodBinding(methodExpression);
    }

    public Validator createValidator(String validatorId) throws FacesException {
        this.checkNull(validatorId, "validatorId");
        this.checkEmpty(validatorId, "validatorId");
        Class validatorClass = this._validatorClassMap.get(validatorId);
        if (validatorClass == null) {
            String message = "Unknown validator id '" + validatorId + "'.";
            log.error((Object)message);
            throw new FacesException(message);
        }
        try {
            return (Validator)validatorClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate validator " + validatorClass), (Throwable)e);
            throw new FacesException("Could not instantiate validator: " + validatorClass, (Throwable)e);
        }
    }

    public ValueBinding createValueBinding(String reference) throws ReferenceSyntaxException {
        ValueExpression valueExpression;
        this.checkNull(reference, "reference");
        this.checkEmpty(reference, "reference");
        try {
            valueExpression = this.getExpressionFactory().createValueExpression(this.threadELContext(), reference, Object.class);
        }
        catch (ELException e) {
            throw new ReferenceSyntaxException((Throwable)e);
        }
        return new ValueExpressionToValueBinding(valueExpression);
    }

    private ELContext threadELContext() {
        return this.getFaceContext().getELContext();
    }

    public String getDefaultRenderKitId() {
        return this._defaultRenderKitId;
    }

    public void setDefaultRenderKitId(String defaultRenderKitId) {
        this._defaultRenderKitId = defaultRenderKitId;
    }

    public StateManager getStateManager() {
        return this._stateManager;
    }

    public void setStateManager(StateManager stateManager) {
        this._stateManager = stateManager;
    }

    private void checkNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException(paramName + " can not be null.");
        }
    }

    private void checkEmpty(String param, String paramName) {
        if (param.length() == 0) {
            throw new NullPointerException("String " + paramName + " can not be empty.");
        }
    }
}

